var ippbxproductversion = "";

function CheckDotNetFx(szDotNetVersion) {
    // Uses the detection method recommended at http://msdn2.microsoft.com/en-us/library/aa480243.aspx
    // to determine whether the .NET Framework 2.0 or 3.5 is installed 

    var bPresent = false;
    var oRegVal;
    var oWsh = new ActiveXObject("WScript.Shell");
    var strVersion = "";
    var iReleaseVersion = -1;

    try {
        if (szDotNetVersion == "2.0") {
            strVersion = "v2.0.50727";
        }
        else if (szDotNetVersion == "3.5") {
            strVersion = "v3.5";
        }
        else if (szDotNetVersion == "4.0") {
            strVersion = "v4\\Full";
        }
        else if (szDotNetVersion == "4.5") {
            strVersion = "v4\\Full";
            iReleaseVersion = 378389;
        }
        else if (szDotNetVersion == "4.5.1") {
            strVersion = "v4\\Full";
            iReleaseVersion = 378675;
        }
        else if (szDotNetVersion == "4.5.2") {
            strVersion = "v4\\Full";
            iReleaseVersion = 379893;
        }
        else if (szDotNetVersion == "4.7.2") {
            strVersion = "v4\\Full";
            iReleaseVersion = 461808;
        }
        else if (szDotNetVersion == "4.8") {
            strVersion = "v4\\Full";
            iReleaseVersion = 528040;
        }
        else {
            return bPresent;
        }

        oRegValInstall = oWsh.RegRead("HKEY_LOCAL_MACHINE\\Software\\Microsoft\\NET Framework Setup\\NDP\\" + strVersion + "\\Install");
        bPresent = (oRegValInstall == 1);

        if (bPresent && (iReleaseVersion >= 0)) {
            oRegValRelease = oWsh.RegRead("HKEY_LOCAL_MACHINE\\Software\\Microsoft\\NET Framework Setup\\NDP\\" + strVersion + "\\Release");
            bPresent = (oRegValRelease >= iReleaseVersion);
        }

    }
    catch (e) {
        bPresent = false;
    };

    oWsh = null;

    return bPresent;
}

// Check for 64 Bit OS
function Is64BitOS() {
    // See "HOWTO: Detect Process Bitness"
    // http://blogs.msdn.com/david.wang/archive/2006/03/26/HOWTO-Detect-Process-Bitness.aspx

    var architecture = "";
    var architecture6432 = "";
    var oWsh = new ActiveXObject("WScript.Shell");

    try {
        var sysEnv = oWsh.Environment("SYSTEM");
        architecture = sysEnv("PROCESSOR_ARCHITECTURE");
        architecture6432 = sysEnv("PROCESSOR_ARCHITEW6432");

        sysEnv = null;
    }
    catch (e) {
    };

    oWsh = null;

    return (architecture.toUpperCase() == "AMD64" || architecture6432.toUpperCase() == "AMD64");
}

function CheckSqlServer() {
    // HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion\CurrentVersion
    var oWsh = new ActiveXObject("WScript.Shell");
    var v = "";
    try {
        // First try. Search MSDE key
        v = oWsh.RegRead("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\MSSQLServer\\MSSQLServer\\CurrentVersion\\CurrentVersion");
    }
    catch (e) {
        try {
            // Second try. Search SQL Express key (Named Instance SQLEXPRESS)
            v = oWsh.RegRead("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\SQLEXPRESS\\MSSQLServer\\CurrentVersion\\CurrentVersion");
        }
        catch (e) {
        }
    };

    oWsh = null;
    var re = /(\d+)\.(\d+)\.(\d+)\.(\d+)/;
    var m = v.match(re);
    if (m == 0) {
        re = /(\d+)\.(\d+)\.(\d+)/;
        m = v.match(re);
    }
    return (m && (m[1] >= 8));
}

function ExtractMajorMinorVersion(versionString) {
    var re = /(\d+)\.(\d+)/;
    var m = versionString.match(re);
    if (m && m.length > 1) {
        return [m[1], m[2]];
    } else {
        return null;
    }
}

function IsVCRedistInstalled(arch, vcRedistRequiredVersion) {
    if (arch != "x86" && arch != "x64") { return false }
    var vcRedistReqMajorMinorVersion = ExtractMajorMinorVersion(vcRedistRequiredVersion)
    var v = "";
    try {
        // Get x64 and x86 version
        var oWsh = new ActiveXObject("WScript.Shell");
        v = oWsh.RegRead("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\\Runtimes\\" + arch + "\\Version");
    }
    catch (e) {
        // ignore exception. We handle failure as version mismatch, i.e. "uninstalled"
    };

    if (v) {
        var v1 = ExtractMajorMinorVersion(v);
        return v1[0] > vcRedistReqMajorMinorVersion[0] || (v1[0] == vcRedistReqMajorMinorVersion[0] && v1[1] >= vcRedistReqMajorMinorVersion[1]);
    } else {
        return false;
    }
}


function InitVersion(version) {
    ippbxproductversion = version;
}

function Init(version, vcRedistRequiredVersion) {
    CheckPrerequisites(vcRedistRequiredVersion);
    InitVersion(version);
    InitWindow();
}

function adaptHeader() {
    document.getElementById("headerimage").width = window.innerWidth;
    // debug window dimensions
    //var iw = document.getElementById("headerimage").width;
    //document.getElementById("version").innerText = "(" + screen.deviceXDPI + "," + screen.deviceYDPI + ")" + " (" + screen.logicalXDPI + "," + screen.logicalYDPI + ")" + " (" + window.outerWidth + "," + window.outerHeight + ") " + iw;
}

function InitWindow() {
    var BASEWIDTH = 500;
    var BASEHEIGHT = 354
    var WIDTH = BASEWIDTH;
    var HEIGHT = BASEHEIGHT;

    if (screen.deviceXDPI > 96) {
        WIDTH = BASEWIDTH * screen.deviceXDPI / 96;
        HEIGHT = BASEHEIGHT * screen.deviceYDPI / 96;
    }

    window.onresize = adaptHeader
    window.resizeTo(WIDTH, HEIGHT);
    adaptHeader();
}

function OpenCHM(szCHM, szTopic) {
    try {
        // Get the absolute CHM path        
        var p = window.document.location.pathname;
        var oFSO = new ActiveXObject("Scripting.FilesystemObject");
        p = oFSO.GetAbsolutePathName(oFSO.GetParentFolderName(p) + "\\" + szCHM);
        oFSO = null;

        // Create the string including the chapter
        p = "\"mk:@MSITStore:" + decodeURIComponent(p) + "::/" + szTopic + "\"";

        var oWsh = new ActiveXObject("WScript.Shell");
        oWsh.Run("hh.exe " + p, 1, false);
        oWsh = null;
    }
    catch (e) {
    }
}

function CheckPrerequisites(vcRedistRequiredVersion) {
    SetInstalled("dotnetfxInstallState", "dotnetfxListItem", CheckDotNetFx("4.8"));
    SetInstalled("msSqlServerInstallState", "msSqlServerListItem", CheckSqlServer());
    SetInstalled("vcredistInstallState64", "vcredist64ListItem", IsVCRedistInstalled("x64", vcRedistRequiredVersion));
    SetInstalled("vcredistInstallState32", "vcredist32ListItem", IsVCRedistInstalled("x86", vcRedistRequiredVersion));

    // repeat check to detect again and update UI when user ran installers
    //window.setTimeout("CheckPrerequisites('"+vcRedistRequiredVersion+"')", 1000);
}

function SetInstalled(InstallStateElemID, ImageElemID, InstallState) {
    try {
        //window.alert(InstallStateElemID + " " + ImageElemID + " " + InstallState);
        if (InstallState) {
            // show installstate
            var oInstallState = document.getElementById(InstallStateElemID);
            oInstallState.style.color = "Green";

            // change list item bullet 
            var oListItem = document.getElementById(ImageElemID);
            oListItem.style.listStyleImage = "url('checkmark.svg')";
        }
        else {
            // hide installstate
            var oInstallState = document.getElementById(InstallStateElemID);
            oInstallState.style.color = "White";

            // change list item bullet 
            var oListItem = document.getElementById(ImageElemID);
            oListItem.style.listStyleImage = "url('arrow.svg')";
        }
    }
    catch (e) {
    }
}

// Install the 32 or 64 Bit version of a program
function StartInstall32_64(prog32, prog64) {
    if (Is64BitOS())
        return StartInstall(prog64, null, true);

    return StartInstall(prog32, null, true);
}

function StartInstall(prog) {
    StartInstall(prog, null, true);
}

function StartInstall(prog, parameter, wait) {
    try {
        // start installation and wait
        var oWsh = new ActiveXObject("WScript.Shell");
        var p = window.document.location.pathname;
        var oFSO = new ActiveXObject("Scripting.FilesystemObject");

        p = oFSO.GetAbsolutePathName(oFSO.GetParentFolderName(p) + "\\" + prog);
        p = "\"" + decodeURIComponent(p) + "\"";

        if (parameter != null)
            p += " " + parameter;

        oFSO = null;
        oWsh.Run(p, 1, wait);
        oWsh = null;
    }
    catch (e) {
    }
}

// Open a PDF document
function OpenPDF(strPdfFile) {
    StartInstall(szExe, null, false);
}

// Open the online help web page
function OpenOnlineHelp(szProduct, szOEM, szCulture, szHelpID) {

    // Create the help URL
    var szHelpURL = "https://help.enreach.com/" + ippbxproductversion + "/" + szProduct + "/" +
        szOEM + "/" + szCulture + "/index.html";

    if (szHelpID != null) {
        szHelpURL += "#context/help/" + szHelpID;
    }

    OpenUrl(szHelpURL)
}

// Open the online ReadMe web page
function OpenOnlineReadMe(szOEM, szCulture, sec) {

    // Create the help URL
    var szHelpURL = "https://help.enreach.com/readme/ReadMe_redirect.html?prod=" +
        szOEM +
        "&lang=" +
        szCulture +
        "&ver=" +
        ippbxproductversion +
        "&sec=" +
        sec;

    OpenUrl(szHelpURL)
}

function OpenUrl(szUrl) {
    // Use shell execute to open the default browser
    try {
        var oWsh = new ActiveXObject("WScript.Shell");
        oWsh.Run(szUrl, 1, false);
        oWsh = null;
    }
    catch (e) { }
}